## 15.6.60.8

- **Improved Streaming Reliability**: Live streaming from I‑PRO cameras is now more consistent across both H.264 and H.265 codecs, providing a smoother and more dependable viewing experience.

## 15.6.60.6

- **Over-the-Air Firmware Updates**: The ION‑R150 now supports OTA firmware updates, enabling seamless remote deployment and improved update management through PERCEPT Cloud.
- **Expanded Camera Support**: The EEN integration now supports the same number of cameras as the available data sources, matching the full configuration limit of 96 for consistent scalability.

## 15.6.60.0

- **Improved Connectivity and Status Reporting**: Devices now provide clearer, more consistent visibility into connectivity and network status by accurately reporting the active network interface, internet reachability, and unified enabled/disabled states across Ethernet, Wi-Fi, and Cellular.
- **Enhanced Eagle Eye Networks Integration**: Integration with Eagle Eye Networks has been improved with full support for EEN V2 and V3 as well as M2M authentication, and the SDS UI now streamlines this workflow by replacing username/password authentication with a refresh token–based approach.
- **Enhanced Genetec Integration**: Genetec datasources now display the correct connection URL and establish successful connections for a more reliable setup experience.

## 15.5.23.6

- **Smoother Video Playback Experience**: Improved handling of video streams ensures a more consistent and uninterrupted viewing experience across various playback scenarios.
- **Improved DNS Configuration**: DNS setup is now more flexible and intuitive, with support for multiple static entries and enhanced management tools for secure and reliable name resolution.

## 15.5.23.2

- **Support for New ION-R300 Hardware**: The firmware now supports the latest ION-R300 hardware revision with three HDMI display ports simultaneously.
- **Basic DNS Configuration**: Initial support added for managing static DNS entries directly in the web interface, enabling faster and more reliable name resolution.

## 15.5.21.0

- **Improved Video Discovery Wizard**: Added support for PTZ configuration when the selected camera source is capable.
- **Enhanced PTZ Keyboard Responsiveness**: Camera movements now respond in near real-time to joystick inputs, ensuring smoother and more precise control during PTZ operations.

## 15.5.20.0

- **Product Upgrade**: A new product revision of the ION-R200 is now available and supported, delivering the same performance and feature set as the previous model.
  - Performance benchmarks, including video streaming, decoding and rendering throughputs, have been validated to match or exceed the specifications of the earlier ION-R200.

## 15.5.19.10

- **Optimized Resolution Selection**: The "Optimal" resolution setting on the ION-R200 now defaults to 1080p when connected to a 4K monitor, ensuring consistent performance. The "Best" resolution setting continues to select 4K resolution.
- **Enhanced Webpage Functionality**: Display and consistency of all properties required for webpage functionality have been improved.
- **Improved Reset Reliability**: Device reset reliability and functionality have been improved across more edge cases.
- **Restored Video Output Identification**: The "Identify Video Outputs" button now correctly identifies and displays all connected video outputs, ensuring seamless functionality.
- **Expanded Certificate Compatibility**: Encryption is now supported with certificates that include only DNS names, ensuring compatibility with common certificate configurations.

## 15.5.19.4

- **PERCEPT Cloud Connectivity Kit**: The new USB-to-Ethernet adapter adds a second Ethernet port to the ION-R100S and ION-R200, providing hot-plug connectivity, persistent network settings, and seamless interface handling across reboots. It ensures secure, dedicated access to PERCEPT Cloud while keeping the Camera LAN isolated from the Internet.
- **Accurate Network Status Updates**: The Web UI now reliably reflects the connection status of LAN 1 after unplugging and replugging, ensuring accurate network discovery on all connected interfaces.
- **Automatic Bonjour Service Registration**: Bonjour services now automatically register new network interfaces when connected, ensuring devices are discoverable on all active interfaces.

## 15.5.16.8

- **Automatic Recovery**: The system now detects and recovers from unexpected application errors by restarting affected components or rebooting the device as needed. This ensures minimal disruption and eliminates the need for manual intervention.

## 15.5.15.36

- **Precise PTZ Control**: Avigilon H3, H4, and H5A cameras now stop PTZ movement immediately when controls are released, ensuring precise operation.
- **Reliable Live Streaming**: Improved error handling to ensure uninterrupted live streaming functionality.
- **Improved Firmware Updates**: The firmware update process now handles additional error conditions that could have caused update failures.

## 15.5.15.26

- **Improved Device Onboarding**: Devices deleted and subsequently re-added to PERCEPT Cloud now come back online successfully within 5 minutes. This ensures a reliable and uninterrupted onboarding process for device management.
- **Automatic RTSP Stream Recovery**: The system now detects and recovers from additional cases of unexpected errors or exceptions in RTSP streams, ensuring uninterrupted streaming functionality without manual intervention.

## 15.5.15.18

- **Stable Genetec Integration**: HTTPS connections with Genetec now maintain a more reliable link, enabling uninterrupted streaming and stable system integration.
- **Improved Milestone Authentication**: Devices now authenticate with Milestone servers on the first attempt, minimizing server resource usage and ensuring audit-friendly log entries for seamless operation.

## 15.5.15.6

- **Enhanced RTSP Compatibility**: Devices now successfully authenticate with Digital Watchdog VMS' RTSP servers, ensuring compatibility and uninterrupted streaming.
- **Hikvision H265 Profile Discovery**: The H265 profile is now displayed during device discovery, allowing users to select and stream using this profile for improved video quality and compatibility.
- **Automatic Reconnection for Decoders**: Cameras now automatically attempt to reconnect when the "Decoder not started" error occurs, minimizing disruption and eliminating the need for manual intervention.
- **Axis Camera Profile Discovery**: Profiles for all Axis camera models, including the Axis M3114, are now discoverable, ensuring compatibility and seamless integration.

## 15.5.5.2

- **Secure Remote Access**: Devices now support remote connectivity using PERCEPT Cloud Secure Tunnelling, enabling safe and reliable access for monitoring and management from any location.
- **Temperature Reporting Support**: Models with temperature sensors (ION-R100S and ION-R200) now support temperature reporting, allowing real-time temperature data to be viewed in the web interface and logged for analysis.

## 15.3.0.8

- **Seamless Orientation Transitions**: Displays now transition smoothly between Landscape and Portrait orientations without visual artifacts, providing a consistent viewing experience.
- **Faster Video Initialization**: Video now initializes and displays within 30 seconds of boot-up, reducing delays and improving usability.
- **Reliable Image Management**: All selected images are now consistently added to carousels, ensuring efficient organization and management of multiple images.
- **Unobstructed Video Streams**: Data sources remain fully visible without overlays obstructing the view, ensuring continuous monitoring of streams.
- **Accurate Cloud Connection Status**: Devices now correctly reflect their PERCEPT Cloud connection status, ensuring that disabled connections are not erroneously reported as active.
- **Stable On-Screen Display (OSD)**: Devices remain fully functional and online when OSD features are enabled, preventing operational disruptions.